/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.base.api.event;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.quiltmc.qsl.base.api.util.QuiltAssertions;
import org.quiltmc.qsl.base.impl.QuiltBaseImpl;
import org.quiltmc.qsl.base.impl.event.EventPhaseData;
import org.quiltmc.qsl.base.impl.event.EventRegistry;
import org.quiltmc.qsl.base.impl.event.PhaseSorting;

public final class Event<T> {
    public static final class_2960 DEFAULT_PHASE = new class_2960("quilt", "default");
    private final Class<? super T> type;
    private final Function<T[], T> implementation;
    private final Lock lock = new ReentrantLock();
    private volatile T invoker;
    private T[] callbacks;
    private final Map<class_2960, EventPhaseData<T>> phases = new LinkedHashMap<class_2960, EventPhaseData<T>>();
    private final List<EventPhaseData<T>> sortedPhases = new ArrayList<EventPhaseData<T>>();

    public static <T> Event<T> create(Class<? super T> type, Function<T[], T> implementation) {
        return new Event<T>(type, implementation);
    }

    public static <T> Event<T> create(Class<? super T> type, T emptyImplementation, Function<T[], T> implementation) {
        return Event.create(type, callbacks -> switch (((Object[])callbacks).length) {
            case 0 -> emptyImplementation;
            case 1 -> callbacks[0];
            default -> implementation.apply((T[])callbacks);
        });
    }

    public static <T> Event<T> createWithPhases(Class<? super T> type, Function<T[], T> implementation, class_2960 ... defaultPhases) {
        QuiltBaseImpl.ensureContainsDefaultPhase(defaultPhases);
        QuiltAssertions.ensureNoDuplicates(defaultPhases, id -> new IllegalArgumentException("Duplicate event phase: " + id));
        Event<T> event = Event.create(type, implementation);
        for (int i = 1; i < defaultPhases.length; ++i) {
            event.addPhaseOrdering(defaultPhases[i - 1], defaultPhases[i]);
        }
        return event;
    }

    public static void listenAll(Object listener, Event<?> ... events) {
        if (events.length == 0) {
            throw new IllegalArgumentException("Tried to register a listener for an empty event list.");
        }
        EventRegistry.listenAll(listener, events);
    }

    private Event(Class<? super T> type, Function<T[], T> implementation) {
        Objects.requireNonNull(type, "Class specifying the type of T in the event cannot be null");
        Objects.requireNonNull(implementation, "Function to generate invoker implementation for T cannot be null");
        this.type = type;
        this.implementation = implementation;
        this.callbacks = (Object[])Array.newInstance(type, 0);
        this.update();
        EventRegistry.register(this);
    }

    public Class<? super T> getType() {
        return this.type;
    }

    public void register(T callback) {
        this.register(DEFAULT_PHASE, callback);
    }

    public void register(class_2960 phaseIdentifier, T callback) {
        Objects.requireNonNull(phaseIdentifier, "Tried to register a callback for a null phase!");
        Objects.requireNonNull(callback, "Tried to register a null callback!");
        this.lock.lock();
        try {
            this.getOrCreatePhase(phaseIdentifier, true).addListener(callback);
            this.rebuildInvoker(this.callbacks.length + 1);
        }
        finally {
            this.lock.unlock();
        }
    }

    public T invoker() {
        return this.invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseOrdering(class_2960 firstPhase, class_2960 secondPhase) {
        Objects.requireNonNull(firstPhase, "Tried to add an ordering for a null phase.");
        Objects.requireNonNull(secondPhase, "Tried to add an ordering for a null phase.");
        if (firstPhase.equals((Object)secondPhase)) {
            throw new IllegalArgumentException("Tried to add a phase that depends on itself.");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            EventPhaseData<T> first = this.getOrCreatePhase(firstPhase, false);
            EventPhaseData<T> second = this.getOrCreatePhase(secondPhase, false);
            EventPhaseData.link(first, second);
            PhaseSorting.sortPhases(this.sortedPhases);
            this.rebuildInvoker(this.callbacks.length);
        }
    }

    private EventPhaseData<T> getOrCreatePhase(class_2960 id, boolean sortIfCreate) {
        EventPhaseData<T> phase = this.phases.get(id);
        if (phase == null) {
            phase = new EventPhaseData(id, this.callbacks.getClass().getComponentType());
            this.phases.put(id, phase);
            this.sortedPhases.add(phase);
            if (sortIfCreate) {
                PhaseSorting.sortPhases(this.sortedPhases);
            }
        }
        return phase;
    }

    private void rebuildInvoker(int newLength) {
        if (this.sortedPhases.size() == 1) {
            this.callbacks = this.sortedPhases.get(0).getListeners();
        } else {
            Object[] newCallbacks = (Object[])Array.newInstance(this.callbacks.getClass().getComponentType(), newLength);
            int newHandlersIndex = 0;
            for (EventPhaseData<T> existingPhase : this.sortedPhases) {
                int length = existingPhase.getListeners().length;
                System.arraycopy(existingPhase.getListeners(), 0, newCallbacks, newHandlersIndex, length);
                newHandlersIndex += length;
            }
            this.callbacks = newCallbacks;
        }
        this.update();
    }

    private void update() {
        this.invoker = this.implementation.apply((T[][])Arrays.copyOf(this.callbacks, this.callbacks.length));
    }

    public String toString() {
        return "Event{type=" + this.type + ", implementation=" + this.implementation + ", phases=" + this.phases + ", sortedPhases=" + this.sortedPhases + "}";
    }
}

